;*
;* includes
;*

#include <sx.inc>

;*
;* configuration options
;*

__FUSE			equ	_FUSEBASE ^ (_TURBO | _OPTIONX | _STACKX | _IRC_4MHZ)
__FUSEX			equ	_FUSEXBASE ^ (_8BANKS | _1PAGE)

;*
;* misc. equates
;*

SAFECLOCKS		equ		10
CHANCOUNT		equ		3
NOTEDELAY		equ		32

;*
;* registers
;*

WIDTH			equ		$08
NEWWIDTH		equ		$09
CTR			equ		$0a
SAMP			equ		$0b
TMP			equ		$0c
CHANCTR			equ		$0d
VOLTIME			equ		$0e
NOTETIME		equ		$0f

; per-channel info
POSLO			equ		$10
POSHI			equ		$11
INCLO			equ		$12
INCHI			equ		$13
VOL			equ		$14
VOLDEC			equ		$15

; tune control bank
TUNEBANK		equ		$E0
TUNEPOS			equ		$10
DELAY			equ		$11
DATAHI			equ		$12
DATALO			equ		$13


;*
;* code
;*

			org		$000

interrupt		; test status of B0
			btfsc		RB,0
			goto		pwm_set

			; B0 is low... start of new value
			bsf		RB,0
			movf		NEWWIDTH,0	; get value
			movwf		WIDTH		; store
			movlw		256-SAFECLOCKS
			subwf		WIDTH,0
			xorlw		0xFF		; negate and sub 1
			movwf		RTCC		; store
			reti				; return

pwm_set
			; set up clock
			bcf		RB,0
			movlw		128-SAFECLOCKS
			addwf		WIDTH,0
			movwf		RTCC		; store

			reti				; return


start			mode		$f		; select DIRECTION
			clrw
			movwf		!RB		; configure PORTB

			mode		$1		; offset $100 for iread

			movlw		b'10011000'	; rtcc ints no prescale
			movwf		!OPTION

			; set speed
			movlw		NOTEDELAY
			movwf		NOTETIME

			; set tune ptr
			bank		TUNEBANK
			movlw		1
			movwf		DELAY
			clrf		TUNEPOS

			; set up for immediate note processing
			movlw		1
			movwf		VOLTIME
			movwf		NOTEDELAY

mainlp			clrf		SAMP		; clear sample acc
			movlw		(CHANCOUNT<<5)-0x20  ; start at last channel
			movwf		CHANCTR

chanlp			movf		CHANCTR,0	; select channel
			movwf		FSR

			movf		INCLO,0		; get low inc
			addwf		POSLO,1		; add it to pos
			btfsc		STATUS,C	; if carry,
			incf		POSHI,1		; inc hi part
			movf		INCHI,0		; get hi inc
			addwf		POSHI,1		; add it to pos

			rrf		VOL,0		; get volume
			andlw		31

			btfsc		POSHI,6		; sq wave
			xorlw		0xFF		; negate
			movwf		TMP
			movlw		d'32'
			addwf		TMP,0		; add 32 offset 0->64

			addwf		SAMP,1		; store in sample

			movlw		0x100-0x20	; advance to next chan
			addwf		CHANCTR,1
			btfsc		STATUS,C
			goto		chanlp

			rrf		SAMP,0		; update PWM sample
			andlw		0x7f
			movwf		NEWWIDTH

			decfsz		VOLTIME,1
			goto		mainlp

			; process volumes every 256 cycles
			movlw		(CHANCOUNT<<5)-0x20
			movwf		CHANCTR
decvlp			movf		CHANCTR,0	; select channel
			movwf		FSR
			decf		VOL,1
			btfsc		STATUS,Z	; stop at 1
			incf		VOL,1

			movlw		0x100-0x20	; advance to next chan
			addwf		CHANCTR,1
			btfsc		STATUS,C
			goto		decvlp

			; next note event?
			decfsz		NOTETIME,1
			goto		mainlp

			; process note control
			bank		TUNEBANK	; select bank
			decfsz		DELAY,1		; dec delay
			goto		notedone

			; need to process event
event			rlf		TUNEPOS,0
			iorlw		b'00000001'
			call		tunetable	; get note data
			movwf		CHANCTR		; tmp storage!
			rlf		TUNEPOS,0
			andlw		b'11111110'
			call		tunetable	; get note data
			movwf		NOTETIME	; tmp storage!
			movwf		TMP

			; extract channel no, select bank
			rrf		TMP,1		; ?DDD CC00
			rrf		TMP,1		; ??DD DCC0
			movlw		b'00000110'
			andwf		TMP,0		; 0000 0CC0
			movwf		FSR		; select bank
			swapf		FSR,1		; 0CC0 0000

			; test to see if it's end of tune
			movlw		b'01100000'
			subwf		FSR,0
			btfsc		STATUS,Z
			goto		song_end

			; reset volume
			movlw		63
			movwf		VOL

			; set freq
			movf		CHANCTR,0
			movwf		INCLO
			movlw		b'00000111'
			andwf		NOTETIME,0
			movwf		INCHI

			; restore bank
			bank		TUNEBANK	; select bank

			; get next note data
			incf		TUNEPOS,1	; advance tune ptr
song_restart		rlf		TUNEPOS,0
			andlw		b'11111110'
			call		tunetable	; get note data
			movwf		DATAHI

			; get delay
			clrf		DELAY
			swapf		DATAHI,1
			rrf		DATAHI,0
			andlw		b'00000111'
			movwf		DELAY

			; repeat if zero!
			btfsc		STATUS,Z
			goto		event

			; ok... we're done
notedone		movlw		NOTEDELAY	; restore count
			movwf		NOTETIME

			goto		mainlp  	; repeat

			; reset song ptr
song_end		bank		TUNEBANK
			clrf		TUNEPOS
			goto		song_restart

;*
;* note data
;*

tunetable		addwf		PC,1
#include "tune.inc"

;*
;* reset entry point
;*

			org		$1ff
reset			goto		start



